function design = tsena_1d(n, d, TSENA)
%TSENA_1D Generates a 1D TSENA array.
%Syntax:
%   design = tsena_1d(n, wavelength/2, 'Nested Array');
%Inputs:
%   n - Parameter pair.
%   d - Inter-element spacing.
%   name - Custom name of the array. Default is 'United array (m, n)'.
%Outputs:
%   design - An array design struct.
if n <= 7
    error('Sensor amount must larger than 7.');
end
% ========= array configuration ============
% ========= decide spacing
n1 = 2*floor((n+3)/4);
n2 = n-n1-1;
l = (n1)/2;
R11 = [];
R11 = [0 l 2*l 2*l+3:3*l];
R12 = [];
R12 = [0 l+1 2*l+2 3*l+3:4*l];
L=[];
LEN_R11 = length(R11);
for left_count = 1:LEN_R11
    L(left_count)=n1+1-R11(left_count);
end
L=sort(L);
R=[];
LEN_R12 = length(R12);
for right_count = 1:LEN_R12
    R(right_count)=R12(right_count) + (n1+1)*(n2+1);
end
M=[];
for middle_count = 1:n2
    M(middle_count) = middle_count*(n1+1);
end





if d <= 0 || ~isreal(d)
    error('d must be a positive real number.');
end
if nargin <= 2
    name = sprintf('TSENA %d sensors', n);
elseif ~ischar(name)
    error('Name must be a string.');
end
A = [L M R];
A = unique(A);
A = sort(A);
design.element_indices = A;
%design.element_indices = union(design.element_indices, (n1*n2+n2+n1-2));
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.dim = 1;
design.type = 'TSENA';
design.name = name;
end